setwd("/home/maciej/pliki/bioinf_2024-2026/s01/bio_struk/taube/WYNIKI_LAB_CD/")

library(ggplot2)

# dichro
lac <- read.table("DICHROWEB/BLACTOGLOBULIN_DICHROWEB_FIT_DATA.txt")

plot(
	x = lac[, 1],
	y = lac[, 2],
	type = 'l',
	col = 'red',
	#ylim = c(-5, 25),
	main = "B-laktoglobulina",
	ylab = "CD ∆ϵ",
	xlab = "długość fali (nm)",
	ylim = c(-20000, 35000)
)
lines(
	x = lac[, 1],
	y = lac[, 3],
	type = 'l',
	col = 'green'
)
legend("topright", legend=c("Dane eksperymentalne", "Dopasowanie DichroWeb"),
	   col=c("red", "green"), lty=1, cex=0.8)

abline(0, 0)

bsa <- read.table("DICHROWEB/BSA_DICHROWEB_FIT_DATA.txt")

plot(
	x = bsa[, 1],
	y = bsa[, 2],
	type = 'l',
	col = 'red',
	#ylim = c(-5, 25),
	main = "BSA",
	ylab = "CD ∆ϵ",
	xlab = "długość fali (nm)",
	ylim = c(-20000, 35000)
)
lines(
	x = bsa[, 1],
	y = bsa[, 3],
	type = 'l',
	col = 'green'
)
legend("topright", legend=c("Dane eksperymentalne", "Dopasowanie DichroWeb"),
	   col=c("red", "green"), lty=1, cex=0.8)

abline(0, 0)

lys <- read.table("DICHROWEB/LYSOZYME_DICHROWEB_FIT_DATA.txt")

plot(
	x = lys[, 1],
	y = lys[, 2],
	type = 'l',
	col = 'red',
	#ylim = c(-5, 25),
	main = "Lizozym",
	ylab = "CD ∆ϵ",
	xlab = "długość fali (nm)",
	ylim = c(-20000, 35000)
)
lines(
	x = lys[, 1],
	y = lys[, 3],
	type = 'l',
	col = 'green'
)
legend("topright", legend=c("Dane eksperymentalne", "Dopasowanie DichroWeb"),
	   col=c("red", "green"), lty=1, cex=0.8)

abline(0, 0)

# B-lac_10x-1.txt  BLac-H2O_smooooooth.txt  BSA-H2O_ASCI.txt
# Liz-H2O_smooooooth_ASCI.txt  Liz-H2O.txt    water_10x-1.txt B-lac-H2O-1.txt
# BSA_10x-1.txt            BSA-H2O.txt       Liz-H2O_smooooooth.txt
# Liz_x10-1.txt

# bsa-h2o.tsv  bsa.tsv  h2o.tsv

var1 <- read.table("DANE_EKSPERYMENTALNE/lys.tsv")
var2 <- read.table("DANE_EKSPERYMENTALNE/lys-h2o.tsv")
var3 <- read.table("DANE_EKSPERYMENTALNE/lyss-h2o.tsv")

plot(
	x = var1[, 1],
	y = var1[, 2],
	type = 'l',
	col = 'red',
	main = "Lizozym",
	ylab = "mdeg",
	xlab = "długość fali (nm)",
	ylim = c(-25, 45)
)
lines(
	x = var2[, 1],
	y = var2[, 2],
	type = 'l',
	col = 'green'
)
lines(
	x = var3[, 1],
	y = var3[, 2],
	type = 'l',
	col = 'purple'
)
abline(0, 0)
legend("topright", legend=c("Dane eksperymentalne", "Po odjęciu widma wody", "Po wygładzeniu"),
	   col=c("red", "green", "purple"), lty=1, cex=0.8)

var1 <- read.table("DANE_EKSPERYMENTALNE/lac.tsv")
var2 <- read.table("DANE_EKSPERYMENTALNE/lac-h2o.tsv")
var3 <- read.table("DANE_EKSPERYMENTALNE/lacs-h2o.tsv")

plot(
	x = var1[, 1],
	y = var1[, 2],
	type = 'l',
	col = 'red',
	main = "B laktoglobulina",
	ylab = "mdeg",
	xlab = "długość fali (nm)",
	ylim = c(-25, 45)
)
lines(
	x = var2[, 1],
	y = var2[, 2],
	type = 'l',
	col = 'green'
)
lines(
	x = var3[, 1],
	y = var3[, 2],
	type = 'l',
	col = 'purple'
)
abline(0, 0)
legend("topright", legend=c("Dane eksperymentalne", "Po odjęciu widma wody", "Po wygładzeniu"),
	   col=c("red", "green", "purple"), lty=1, cex=0.8)

var1 <- read.table("DANE_EKSPERYMENTALNE/bsa.tsv")
var2 <- read.table("DANE_EKSPERYMENTALNE/bsa-h2o.tsv")

plot(
	x = var1[, 1],
	y = var1[, 2],
	type = 'l',
	col = 'red',
	main = "BSA",
	ylab = "mdeg",
	xlab = "długość fali (nm)",
	ylim = c(-25, 45)
)
lines(
	x = var2[, 1],
	y = var2[, 2],
	type = 'l',
	col = 'green'
)
abline(0, 0)
legend("topright", legend=c("Dane eksperymentalne", "Po odjęciu widma wody"),
	   col=c("red", "green"), lty=1, cex=0.8)

var1 <- read.table("DANE_EKSPERYMENTALNE/h2o.tsv")

plot(
	x = var1[, 1],
	y = var1[, 2],
	type = 'l',
	main = "Woda",
	ylab = "mdeg",
	xlab = "długość fali (nm)",
	ylim = c(-25, 40)
)

# BLACTOGLOBULIN_DICHROWEB_FIT_DATA.txt  BSA_DICHROWEB_FIT_DATA.txt
# LYSOZYME_DICHROWEB_FIT_DATA.txt

var1 <- read.table("DANE_EKSPERYMENTALNE/bsa.csv", sep = ',')
var2 <- read.table("DICHROWEB/BSA_DICHROWEB_FIT_DATA.txt")

plot(
	x = var1[, 1],
	y = var1[, 2],
	type = 'l',
	col = 'red',
	main = "BSA",
	ylab = "∆ϵ",
	xlab = "długość fali (nm)",
	ylim = c(-5, 10)
)
lines(
	x = var1[, 1],
	y = var1[, 3],
	type = 'l',
	col = 'green'
)
lines(
	x = 185:240,
	y = var2[, 3] / 3298,
	type = 'l',
	col = 'purple'
)
abline(0, 0)
legend("topright", legend=c("Dane eksperymentalne", "Dopasowanie BestSel", "Dopasowanie CDSSTR"),
	   col=c("red", "green", "purple"), lty=1, cex=0.8)

var1 <- read.table("DANE_EKSPERYMENTALNE/lac.csv", sep = ',')
var2 <- read.table("DICHROWEB/BLACTOGLOBULIN_DICHROWEB_FIT_DATA.txt")

plot(
	x = var1[, 1],
	y = var1[, 2],
	type = 'l',
	col = 'red',
	main = "B-laktoglobulina",
	ylab = "∆ϵ",
	xlab = "długość fali (nm)",
	ylim = c(-5, 10)
)
lines(
	x = var1[, 1],
	y = var1[, 3],
	type = 'l',
	col = 'green'
)
lines(
	x = 185:240,
	y = var2[, 3] / 3298,
	type = 'l',
	col = 'purple'
)
abline(0, 0)
legend("topright", legend=c("Dane eksperymentalne", "Dopasowanie BestSel", "Dopasowanie CDSSTR"),
	   col=c("red", "green", "purple"), lty=1, cex=0.8)

var1 <- read.table("DANE_EKSPERYMENTALNE/lys.csv", sep = ',')
var2 <- read.table("DICHROWEB/LYSOZYME_DICHROWEB_FIT_DATA.txt")

plot(
	x = var1[, 1],
	y = var1[, 2],
	type = 'l',
	col = 'red',
	main = "Lizozym",
	ylab = "∆ϵ",
	xlab = "długość fali (nm)",
	ylim = c(-5, 10)
)
lines(
	x = var1[, 1],
	y = var1[, 3],
	type = 'l',
	col = 'green'
)
lines(
	x = 185:240,
	y = var2[, 3] / 3298,
	type = 'l',
	col = 'purple'
)
abline(0, 0)
legend("topright", legend=c("Dane eksperymentalne", "Dopasowanie BestSel", "Dopasowanie CDSSTR"),
	   col=c("red", "green", "purple"), lty=1, cex=0.8)


library(ggplot2)

# Create data frame from grid
df <- expand.grid(x = 4:9, y = c(4.0, 4.4, 4.8, 5.2))
#df$z <- with(df, sin(sqrt(x^2 + y^2)))

# stosunkowe długości największych kryształów w próbie
df$z <- c(
	1.2, 2.0, 1.4, 1.2, 1.4, 1.4,
	3.0, 4.0, 3.0, 2.8, 1.8, 2.7,
	3.7, 0.0, 4.0, 5.0, 3.0, 3.0,
	0.0, 0.0, 3.7, 7.0, 9.5, 9.0
) / 1.2

# Plot heatmap
ggplot(df, aes(x, y, fill = z)) +
	geom_tile() +
	scale_fill_gradient(low = "yellow", high = "red") +
	labs(title = "Stosunkowy rozmiar największego kryształu dla kombinacji warunków") +
	xlab("Stężenie NaCl (%)") +
	ylab("pH") + 
	scale_x_continuous(breaks = 4:9) +
	scale_y_continuous(breaks = c(4.0, 4.4, 4.8, 5.2)) +
	theme_grey()


# polaryzacja kołowa

x1 <- seq(
	from = 0,
	to = 2 * pi + 0.1,
	by = 0.1
)
colors <- c(
	"red",
	"blue",
	"purple",
	"violet",
	"yellow",
	"orange",
	"pink",
	"green",
	"darkorange",
	"darkred"
)
plot(
	x = sin(x1),
	y = cos(x1 - pi),
	type = 'l',
	xlab = "Fala elektryczna",
	ylab = "Fala magnetyczna",
)
lines(
	x = sin(x1),
	y = cos(x1 - pi / 2),
	col = 'blue'
)

for(i in 1:3) {
	lines(
		x = sin(x1),
		y = i * cos(x1),
		type = 'l',
		col = colors[i]
	)
}
x2 <- seq(0, 6 * pi, 0.1)
plot(
	sin(x2),
	col = "red",
	type = 'l',
	ylim = c(-2, 2),
	ylab = "amplitude",
	xlab = "time"
)
abline(0, 0)
lines(
	cos(x2 - pi),
	col = 'blue'
)
lines(
	sin(x2) + cos(x2 + pi / 2 + 0.1),
	col = 'purple'
)
